﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Web.Script.Serialization;
using VeteransAffairs.Registries.BusinessAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR.MilitaryInfoService;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;


namespace VeteransAffairs.Registries.BusinessManagerAHOBPR.Emis
{
    public class BprDeploymentManager : AHOBPRBaseBO
    {
        private string connectionInfo = String.Empty;
        private Dictionary<string, string> countryLookup;
        RegistrantDeploymentUtilities regDeploymentUtilities;
        public BprDeploymentManager() { }
        public BprDeploymentManager(string dbConnectionInfo)
        {
            connectionInfo = dbConnectionInfo;
        }
        private Dictionary<string, string> CountryLookup
        {
            get
            {
                if (countryLookup == null)
                {
                    using (_dbAhobpr = GetLocalContext(connectionInfo))
                    {
                        countryLookup = _dbAhobpr.STD_COUNTRies.ToDictionary(r => r.CODE, r => r.DESCRIPTION);
                    }
                }
                return countryLookup;
            }
        }
        public RegistrantDeploymentUtilities RegDeploymentUtilities
        {
            get
            {
                if (regDeploymentUtilities == null)
                {
                    regDeploymentUtilities = new RegistrantDeploymentUtilities(connectionInfo);
                }
                return regDeploymentUtilities;
            }
        }
        public void ProcessDeploymentCountry(REGISTRANT_DEPLOYMENT deployment, string unverifiedDeploymentCountry)
        {
            //Registrant portal has their country list hardcoded and may be out of date
            //Update with the correct value if necessary
            if (CountryLookup.Keys.Contains(unverifiedDeploymentCountry))
            {
                deployment.DEPLOYMENT_COUNTRY = CountryLookup[unverifiedDeploymentCountry];
            }
            else
            {
                deployment.DEPLOYMENT_COUNTRY = unverifiedDeploymentCountry;
            }
        }

        public string ConvertDeploymentCountryCodeToName( string countryCode)
        {
            var result = countryCode;
            //Registrant portal has their country list hardcoded and may be out of date
            //Update with the correct value if necessary
            if (CountryLookup.Keys.Contains(countryCode))
            {
                result = CountryLookup[countryCode];
            }
            return result;
        }

        public BprDoDDeploymentImports GetBprDoDDeploymentImports(REGISTRANT registrant)
        {
            var history = new RegistrantHistory();
            history.BranchesOfService = new BranchesOfServiceManager().GetRegistrantsBranchesOfService(registrant.EDIPI);
            // Create Hybrid Registrant Deployments object
            BprDoDDeploymentImports registrantWithDeployments = MergeRegistrantWithDoDDeploymentImport(registrant, registrant.EDIPI, registrant.Snum);
            //add deployments to Hybrid Registrant Deployments Object
            try
            {
                var factory = new BprDoDDeploymentFactory(connectionInfo);
                var importer = new DoDDeploymentImporter();            
                var t = importer.GetRegistrantDeployments(history, registrant.EDIPI, factory);
                registrantWithDeployments.deployments = t.Cast<BprDoDDeployment>().ToArray();
            }
            catch (ArgumentNullException ex)
            {
                AHOBPRLogger.LogErrorMessage("Null Argument", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.ParamName);
            }
            return registrantWithDeployments;
        }

        //public BprDoDDeploymentImports GetBprDoDDeploymentImports(REGISTRANT registrant)
        //{

        //    Dictionary<DateRange, string> branchesOfService = new BranchesOfServiceManager().GetRegistrantsBranchesOfService(registrant.EDIPI);
        //    // Create Hybrid Registrant Deployments object
        //    BprDoDDeploymentImports registrantWithDeployments = MergeRegistrantWithDoDDeploymentImport(registrant, registrant.EDIPI, registrant.Snum);


        //    //add deployments to Hybrid Registrant Deployments Object
        //    try
        //    {
        //        var factory = new BprDoDDeploymentFactory();
        //        registrantWithDeployments.deployments = (BprDoDDeployment[])GetRegistrantDeployments(branchesOfService, registrant.EDIPI, factory).ToArray();
        //    }
        //    catch (ArgumentNullException ex)
        //    {
        //        AHOBPRLogger.LogErrorMessage("Null Argument", this.GetType().Name + "." + System.Reflection.MethodBase.GetCurrentMethod().Name, ex.ParamName);
        //    }
        //    return registrantWithDeployments;
        //}

        private BprDoDDeploymentImports MergeRegistrantWithDoDDeploymentImport(REGISTRANT registrant, string edipi, string ssn)
        {
            var registrantWithDeployments = new BprDoDDeploymentImports();
            registrantWithDeployments.edipi = edipi;
            registrantWithDeployments.ssn = ssn;
            if (registrant != null)
            {
                registrantWithDeployments._id = registrant.REGISTRANT_ID.ToString(CultureInfo.InvariantCulture);
                registrantWithDeployments.dob = registrant.BIRTH_DATE.HasValue ? Convert.ToDateTime(registrant.BIRTH_DATE).ToUniversalTime().ToString("yyyy'-'MM'-'dd'T'HH':'mm':'ss'.'fff'Z'", CultureInfo.InvariantCulture) : string.Empty;
                registrantWithDeployments.firstName = registrant.FIRST_NAME;
                registrantWithDeployments.importId = registrant.REGISTRANT_ID.ToString(CultureInfo.InvariantCulture);
                registrantWithDeployments.lastName = registrant.LAST_NAME;
                registrantWithDeployments.middleName = registrant.MIDDLE_NAME;
            }
            return registrantWithDeployments;
        }
        public BprDoDDeployment CreateDeployment(string branchOfService, DeploymentLocation location)
        {
            if (location == null)
                throw new ArgumentNullException(nameof(location));

            var deployment = new BprDoDDeployment();
            deployment.dutyProjectCode = string.Empty;
            //A deploymentlocation will either have a country OR a major body of water code
            deployment.deploymentCountryCode = location.deploymentCountry ?? location.deploymentLocationMajorBodyOfWaterCode;
            DateRange deploymentDateRange = AHOBPRShared.CreateNewDateRange(location.deploymentLocationBeginDate, location.deploymentLocationEndDate);
            deployment.deploymentStartDate = deploymentDateRange.Start.ToShortDateString();
            deployment.deploymentEndDate = deploymentDateRange.End.ToShortDateString();
            deployment.branchOfService = branchOfService;
            return deployment;
        }
        public REGISTRANT_DEPLOYMENT ProcessDeployment(REGISTRANT registrant, REGISTRANT_DEPLOYMENT deployment, BprDeploymentHistory bprDeploymentItem, bool newDeployment, int branchOfServiceId)
        {
           
            if (newDeployment)
            {
                deployment = new REGISTRANT_DEPLOYMENT();
                deployment.STD_DEPLOYMENT_STAGE_ID = (int)Enums.DeploymentStage.NotSet;
            }
            var bprResponses = GetBprResponsesFromJsonData(registrant?.USER_ID);
            var hasDeploymentsInQuestionnaire = bprResponses.responses.Any(r =>  r.sectionId == "1" && r.subSectionId == "2" && r.questionId == "B");
           // var merp = bprResponses.responses.Where(r => r.sectionId == "1" && r.subSectionId == "2" && r.questionId == "B").ToList();
            deployment.REGISTRANT_ID = registrant.REGISTRANT_ID;
            deployment.DEPLOYMENT_BASE = bprDeploymentItem.deploymentBase;
            ProcessDeploymentCountry(deployment, bprDeploymentItem.deploymentCountry);
            deployment.DUTY_PROJECT_CODE = bprDeploymentItem.dutyProjectCode;
            if (!string.IsNullOrEmpty(bprDeploymentItem.deploymentStartDate))
            {
                deployment.DEPLOYMENT_START_DATE = DateTimeOffset.Parse(bprDeploymentItem.deploymentStartDate).UtcDateTime;
            }
            if (!string.IsNullOrEmpty(bprDeploymentItem.deploymentEndDate))
            {
                deployment.DEPLOYMENT_END_DATE = DateTimeOffset.Parse(bprDeploymentItem.deploymentEndDate).UtcDateTime;
            }
            if (!string.IsNullOrEmpty(bprDeploymentItem.lastUpdated))
            {
                deployment.LAST_UPDATED_DATE = DateTimeOffset.Parse(bprDeploymentItem.lastUpdated).UtcDateTime;
            }
            deployment.USER_ENTERED_FLAG = bprDeploymentItem.userEntered;
            deployment.USER_VERIFIED_FLAG = bprDeploymentItem.userVerified;
            deployment.IS_ELIGIBLE_FLAG = bprDeploymentItem.isEligible;
            //Update the  deployment stage
            /**/
            
            RegDeploymentUtilities.SetDeploymentStage(deployment, registrant.STD_REGISTRANT_STATUS_ID, hasDeploymentsInQuestionnaire);
            deployment.IS_GULF_WAR_VETERAN_FLAG = bprDeploymentItem.isGulfWarVeteran;
            deployment.PREVIOUS_VALUES = bprDeploymentItem.previousValues;
            deployment.BPR_DEPLOYMENT_ID = bprDeploymentItem._id;
            if (!string.IsNullOrEmpty(bprDeploymentItem.previousUpdated))
            {
                deployment.PREVIOUS_UPDATED_DATE = DateTimeOffset.Parse(bprDeploymentItem.previousUpdated).UtcDateTime;
            }
            if (branchOfServiceId > 0)
            {
                deployment.STD_BRANCH_OF_SERVICE_ID = branchOfServiceId;
            }
            if (!String.IsNullOrEmpty(bprDeploymentItem.personnelCategoryCode))
            {
                deployment.STD_COMPONENT_ID = AHOBPRShared.GetStdComponent(bprDeploymentItem.personnelCategoryCode);
            }
            String provenanceSource = "NA";
            if (bprDeploymentItem.provenance != null &&
                !String.IsNullOrEmpty(bprDeploymentItem.provenance.source))
            {
                provenanceSource = bprDeploymentItem.provenance.source;
            }
            if (newDeployment)
            {
                deployment.CREATEDBY = provenanceSource;
                deployment.UPDATEDBY = provenanceSource;
                registrant.REGISTRANT_DEPLOYMENTs.Add(deployment);
                registrant.REGISTRANT_DEPLOYMENTs.Last().SetAsInsertOnSubmit();
            }

            return deployment;
        }
        /// <summary>
        /// We need to know if the registrant has answered any questions in a section of the Registrant Form in order to set the DeploymentStage but in some cases
        /// the json hasn't been parsed into the DB when the DeploymentStage is being set. The method checks the JSON itself.
        /// </summary>
        /// <param name="registrantId"></param>
        /// <returns></returns>
        public BprResponses GetBprResponsesFromJsonData(string jsonObjectId)
        {
            BprResponses responses = null;
            using (var db = GetLocalContext(connectionInfo))
            {
                if (!string.IsNullOrEmpty(jsonObjectId))
                {
                    var registrantJson = AHOBPRShared.GetCurrentJsonFromDb(jsonObjectId, AHOBPRGlobal.AhobprJsonDataTypeResponses, db);
                    if (registrantJson != null)
                    {
                        JavaScriptSerializer serializer = new JavaScriptSerializer();
                        responses = serializer.Deserialize<BprResponses>(registrantJson.JSON_DATA);
                    }
                }
            }
            return responses != null ? responses : new BprResponses();
        }
    }
}
